*-------------------------------------------------------------------------------
*						Appendix III Fig 1 and Appendix III Fig2
*-------------------------------------------------------------------------------

** Set Path
global Raw_data    	"G:\project-finished\Descriptive\Data"
global App_data    	"G:\project-finished\Descriptive\Appendix Data"
global Class_data   "G:\project-finished\Descriptive\Classification"  
global Work_lab   	"G:\project-finished\Descriptive\Lab"
global Out_lab    	"G:\project-finished\Descriptive\Out" 

cd "$Work_lab"
                            
capture log close            
log using "$Out_lab\Appendix III Fig 1 and Appendix III Fig2", replace 
set more off     


**------------------------------------------------------------------------------
* Step1: Generate Data
**------------------------------------------------------------------------------
clear
set obs 0


gen index=""
foreach i in "2000_v5" "2000_v151" "2000_v20" "2000_v25" "2010_v5" "2010_v151" "2010_v20" "2010_v25" "2015_v5" "2015_v151" "2015_v20" "2015_v25" {
append using "CHN`i'.dta"
replace index="`i'" if index==""
}

rename *_std std_*

gen index1_competition=std_Competition
gen index2_interact=(std_interact1 + std_interact2 + std_interact3 + std_interact4)/4
gen index3_cognitive=(std_Cognitive1 + std_Cognitive2 + std_Cognitive3 + std_Cognitive4)/4
gen index4_physical=(std_physical2 + std_physical1)/2
gen index5_routinemanual=(std_routinemanual1+std_routinemanual2+std_routinemanual3)/3
gen index6_routinecognitive=(std_routinecogni1+std_routinecogni2+std_routinecogni3)/3


keep index* share
collapse (sum) share,by(index*)
split index, parse(_)
destring index1,gen(year)
gen version="15" if index2=="v151"
replace version="20" if index2=="v20"
replace version="05" if index2=="v5"
replace version="25" if index2=="v25"

drop index1 index2


label var index3_cognitive "认知能力"
label var index4_physical "体力能力"

label var index5_routinemanual "重复性体力"
label var index6_routinecognitive "重复性认知"

label var index1_competition "竞争要求"
label var index2_interact "协同要求"

rename index*_* .*

replace version= "O*NET " +version

*----------Stick to given version, different year skill change----------------
foreach var of varlist competition-routinecognitive{
preserve
sort index `var'
bys index:gen cum_share_`var'=sum(share)

*skill (only structure change),by different version
twoway (line cum_share_`var' `var' if year==2000, sort lcolor(black%20) lp(dash)) ///
(line cum_share_`var' `var' if year==2010, sort lcolor(black%60) lp(longdash)) ///
(line cum_share_`var' `var' if year==2015, sort lcolor(black) lp(solid)), /// 
legend(label(1 "2000") label(2 "2010") label(3 "2015")  rows(1)) ///
by(version, iyaxes ixaxes note("") rows(2) legend(pos(6) ring(0)) ) ///
ytitle("累计就业占比（%）") xline(0,lcolor(red) lp(dash_dot)) xlabel(,nogrid) ylabel(0(20)100,nogrid)  scheme(plotplain)
graph save "$Out_lab\appIII_Fig1`var'",replace
graph export "$Out_lab\appIII_Fig1`var'.png",replace

restore
}

*----------2000census--onet5, 2010census--onet15 2015census--onet20----------------
keep if index=="2000_v5"|index=="2010_v151"|index=="2015_v20"

foreach var of varlist competition-routinecognitive{
preserve
sort index `var'
bys index:gen cum_share_`var'=sum(share)

*skill (only structure change),by different version
twoway (line cum_share_`var' `var' if year==2000, sort lcolor(black%20) lp(dash)) ///
(line cum_share_`var' `var' if year==2010, sort lcolor(black%60) lp(longdash)) ///
(line cum_share_`var' `var' if year==2015, sort lcolor(black) lp(solid)), /// 
legend(label(1 "2000") label(2 "2010") label(3 "2015") position(6) rows(1)) ///
ytitle("累计就业占比（%）") xline(0,lcolor(red) lp(dash_dot)) xlabel(,nogrid) ylabel(0(20)100,nogrid)  scheme(plotplain)
graph save "$Out_lab\appIII_Fig2`var'",replace
graph export "$Out_lab\appIII_Fig2`var'.png",replace

restore
}

log close


